//Caption: To obtain Digital IIR Butterworth low pass filter
//Frequency response
clc; 
clear;
close;
fp= input('Enter the pass band edge (Hz) = ');
fs= input('Enter the stop band edge (Hz) = ');
kp= input('Enter the pass band attenuation (dB) = ');
ks= input('Enter the stop band attenuation (dB) = ');
Fs= input('Enter the sampling rate  samples/sec = '); 
d1 = 10^(kp/20);
d2 = 10^(ks/20);
d = sqrt((1/(d2^2))-1);
E = sqrt((1/(d1^2))-1);
//Digital filter specifications(rad/samples)
wp=2*%pi*fp*1/Fs; 
ws=2*%pi*fs*1/Fs;
disp(wp,'Digital Pass band edge freq in rad/samples wp=')
disp(ws,'Digital Stop band edge freq in rad/samples ws=')
//Pre warping
op=2*Fs*tan(wp/2);
os=2*Fs*tan(ws/2);
disp(op,'Analog Pass Band Edge Freq. in rad/sec op=')
disp(os,'Analog Stop band Edge Freq. in rad/sec os=')
N = log10(d/E)/log10(os/op);
oc = op/((E^2)^(1/(2*N)));
N = ceil(N);//rounded to nearest integer
disp(N,'IIR Filter order N =');
disp(oc,'Cutoff Frequency in rad/seconds OC = ')
[pols,gn] = zpbutt(N,oc);
disp(gn,'Gain of Analog IIR Butterworth LPF Gain =')
disp(pols,'Poles of Analog IIR Butterworth LPF Poles =')
HS = poly(gn,'s','coeff')/real(poly(pols,'s'));
disp(HS,'Transfer function of Ananlog IIR Butterworth LPF H(S)=')
z = poly(0,'z')
Hz = horner(HS,(2*Fs*(z-1)/(z+1)))
num = coeff(Hz(2))
den = coeff(Hz(3))
Hz(2)= Hz(2)./den(3);
Hz(3) = Hz(3)./den(3);
disp(Hz,'Transfer function of Digitla IIR Butterworth LPF H(Z)=')
[Hw,w] = frmag(Hz,256);
figure(1)
plot(2*w*%pi,20*log10(abs(Hw)));
xlabel('Digital Frequency w--->')
ylabel('Magnitude in dB 20log|H(w)|=')
title('Magnitude Response of IIR LPF')
xgrid(1)
//Result
//Enter the pass band edge (Hz) =  1500
//
//Enter the stop band edge (Hz) =  2000
//
//Enter the pass band attenuation (dB) =  -1
//
//Enter the stop band attenuation (dB) =  -3
//
//Enter the sampling rate  samples/sec =  8000
// 
// Digital Pass band edge freq in rad/samples wp=   
// 
//    1.1780972  
// 
// Digital Stop band edge freq in rad/samples ws=   
// 
//    1.5707963  
// 
// Analog Pass Band Edge Freq. in rad/sec op=   
// 
//    10690.858  
// 
// Analog Stop band Edge Freq. in rad/sec os=   
// 
//    16000.  
// 
// IIR Filter order N =   
// 
//    2.  
// 
// Cutoff Frequency in rad/seconds OC =    
// 
//    16022.769  
// 
// Gain of Analog IIR Butterworth LPF Gain =   
// 
//    2.567D+08  
// 
// Poles of Analog IIR Butterworth LPF Poles =   
// 
//  - 11329.809 + 11329.809i  - 11329.809 - 11329.809i  
// 
// Transfer function of Ananlog IIR Butterworth LPF H(S)=   
// 
//            2.567D+08            
//    -------------------------    
//                              2  
//    2.567D+08 + 22659.618s + s   
// 
// Transfer function of Digitla IIR Butterworth LPF H(Z)=   
// 
//                                       2  
//    0.2933099 + 0.5866197z + 0.2933099z   
//    -----------------------------------   
//                                  2       
//        0.1715734 + 0.0016661z + z        
// 
